/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import java.util.HashSet;
import java.util.Set;

public final class LayoutEntityType {
    public static final int NONE = 0;
    public static final int PAGE = 1;
    public static final int COLUMN = 2;
    public static final int ROW = 8;
    public static final int CELL = 16;
    public static final int LINE = 32;
    public static final int SPAN = 64;
    public static final int FOOTNOTE = 256;
    public static final int ENDNOTE = 512;
    public static final int NOTE = 16384;
    public static final int HEADER_FOOTER = 1024;
    public static final int TEXT_BOX = 2048;
    public static final int COMMENT = 4096;
    public static final int NOTE_SEPARATOR = 8192;
    public static final int length = 14;

    private LayoutEntityType() {
    }

    public static String getName(int layoutEntityType) {
        switch (layoutEntityType) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "PAGE";
            }
            case 2: {
                return "COLUMN";
            }
            case 8: {
                return "ROW";
            }
            case 16: {
                return "CELL";
            }
            case 32: {
                return "LINE";
            }
            case 64: {
                return "SPAN";
            }
            case 256: {
                return "FOOTNOTE";
            }
            case 512: {
                return "ENDNOTE";
            }
            case 16384: {
                return "NOTE";
            }
            case 1024: {
                return "HEADER_FOOTER";
            }
            case 2048: {
                return "TEXT_BOX";
            }
            case 4096: {
                return "COMMENT";
            }
            case 8192: {
                return "NOTE_SEPARATOR";
            }
        }
        return "Unknown LayoutEntityType value.";
    }

    public static Set<String> getNames(int layoutEntityType) {
        HashSet<String> hashSet = new HashSet<String>();
        if ((0 & layoutEntityType) == 0) {
            hashSet.add("NONE");
        }
        if ((1 & layoutEntityType) == 1) {
            hashSet.add("PAGE");
        }
        if ((2 & layoutEntityType) == 2) {
            hashSet.add("COLUMN");
        }
        if ((8 & layoutEntityType) == 8) {
            hashSet.add("ROW");
        }
        if ((0x10 & layoutEntityType) == 16) {
            hashSet.add("CELL");
        }
        if ((0x20 & layoutEntityType) == 32) {
            hashSet.add("LINE");
        }
        if ((0x40 & layoutEntityType) == 64) {
            hashSet.add("SPAN");
        }
        if ((0x100 & layoutEntityType) == 256) {
            hashSet.add("FOOTNOTE");
        }
        if ((0x200 & layoutEntityType) == 512) {
            hashSet.add("ENDNOTE");
        }
        if ((0x4000 & layoutEntityType) == 16384) {
            hashSet.add("NOTE");
        }
        if ((0x400 & layoutEntityType) == 1024) {
            hashSet.add("HEADER_FOOTER");
        }
        if ((0x800 & layoutEntityType) == 2048) {
            hashSet.add("TEXT_BOX");
        }
        if ((0x1000 & layoutEntityType) == 4096) {
            hashSet.add("COMMENT");
        }
        if ((0x2000 & layoutEntityType) == 8192) {
            hashSet.add("NOTE_SEPARATOR");
        }
        return hashSet;
    }

    public static String toString(int layoutEntityType) {
        switch (layoutEntityType) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Page";
            }
            case 2: {
                return "Column";
            }
            case 8: {
                return "Row";
            }
            case 16: {
                return "Cell";
            }
            case 32: {
                return "Line";
            }
            case 64: {
                return "Span";
            }
            case 256: {
                return "Footnote";
            }
            case 512: {
                return "Endnote";
            }
            case 16384: {
                return "Note";
            }
            case 1024: {
                return "HeaderFooter";
            }
            case 2048: {
                return "TextBox";
            }
            case 4096: {
                return "Comment";
            }
            case 8192: {
                return "NoteSeparator";
            }
        }
        return LayoutEntityType.toStringSet(layoutEntityType);
    }

    public static String toStringSet(int attr) {
        String string = "";
        String string2 = "";
        for (int n : LayoutEntityType.getValues()) {
            if (n == 0 || (n & attr) != n) continue;
            string = string + string2 + LayoutEntityType.toString(n);
            string2 = ", ";
        }
        return string;
    }

    public static int fromName(String layoutEntityTypeName) {
        if ("NONE".equals(layoutEntityTypeName)) {
            return 0;
        }
        if ("PAGE".equals(layoutEntityTypeName)) {
            return 1;
        }
        if ("COLUMN".equals(layoutEntityTypeName)) {
            return 2;
        }
        if ("ROW".equals(layoutEntityTypeName)) {
            return 8;
        }
        if ("CELL".equals(layoutEntityTypeName)) {
            return 16;
        }
        if ("LINE".equals(layoutEntityTypeName)) {
            return 32;
        }
        if ("SPAN".equals(layoutEntityTypeName)) {
            return 64;
        }
        if ("FOOTNOTE".equals(layoutEntityTypeName)) {
            return 256;
        }
        if ("ENDNOTE".equals(layoutEntityTypeName)) {
            return 512;
        }
        if ("NOTE".equals(layoutEntityTypeName)) {
            return 16384;
        }
        if ("HEADER_FOOTER".equals(layoutEntityTypeName)) {
            return 1024;
        }
        if ("TEXT_BOX".equals(layoutEntityTypeName)) {
            return 2048;
        }
        if ("COMMENT".equals(layoutEntityTypeName)) {
            return 4096;
        }
        if ("NOTE_SEPARATOR".equals(layoutEntityTypeName)) {
            return 8192;
        }
        throw new IllegalArgumentException("Unknown LayoutEntityType name.");
    }

    public static int fromNames(Set<String> layoutEntityTypeNames) {
        int n = 0;
        for (String string : layoutEntityTypeNames) {
            n |= LayoutEntityType.fromName(string);
        }
        return n;
    }

    public static int[] getValues() {
        return new int[]{0, 1, 2, 8, 16, 32, 64, 256, 512, 16384, 1024, 2048, 4096, 8192};
    }
}

